varying vec2 		texcoord;
uniform sampler2D 	tex;
//uniform sampler2D	ramp;

uniform vec3		colorize;
uniform float		saturate;
uniform vec3		contrast,
					brightness;
					
uniform vec3		inGamma,
					inBlack,
					inWhite,
					outBlack,
					outWhite;

vec3				one=vec3(1.0,1.0,1.0);
vec3				hlf=vec3(0.5,0.5,0.5);

vec3 			rmul,
				rscr;
vec4 			color;
float			lum;
float			OneMinusSat,
				lumsat;

void main()
{
	color=texture2D(tex,texcoord);
	
	// BRIGHTNESS & CONTRAST
	color.xyz = ((color.xyz-hlf)*contrast) + hlf + brightness;
	
	// COLORIZATION
	rmul=color.xyz*colorize;
	rscr=one-((one-colorize)*(one-color.xyz));
	color.xyz=color.xyz*rscr+(one-color.xyz)*rmul;

	//desaturate /////////////////////////////////
	lum=dot(color.rgb,vec3(0.3,0.59,0.11));
	OneMinusSat=saturate;
	lumsat=lum*(1.0-saturate);
	color.r=lumsat+color.r*OneMinusSat;
	color.g=lumsat+color.g*OneMinusSat;
	color.b=lumsat+color.b*OneMinusSat;
	
	// COLOR CORRECTION	/////////////////////////
	color.r = (pow((color.r - inBlack.r) / (inWhite.r - inBlack.r), inGamma.r) * (outWhite.r - outBlack.r) + outBlack.r);
	color.g = (pow((color.g - inBlack.g) / (inWhite.g - inBlack.g), inGamma.g) * (outWhite.g - outBlack.g) + outBlack.g);
	color.b = (pow((color.b - inBlack.b) / (inWhite.b - inBlack.b), inGamma.b) * (outWhite.b - outBlack.b) + outBlack.b);
				
	gl_FragColor.xyz = max(vec3(0.0),color.xyz);
}
